       IDENTIFICATION  DIVISION.
      *
      * Relativity Modernization Workbench Reference Implementation COBOL/CICS/VSAM Application
      *
      * Author: Nic Walsh February 2002
      *
      * This program invokes the main menu
      *
       PROGRAM-ID.  INVMENU.
      *
       ENVIRONMENT DIVISION.
      *
       DATA DIVISION.
      *
       WORKING-STORAGE SECTION.
      *
       01  SWITCHES.
      *
           05  VALID-DATA-SW           PIC X     VALUE 'Y'.
               88  VALID-DATA                    VALUE 'Y'.
      *
       01  FLAGS.
      *
           05  SEND-FLAG               PIC X.
               88  SEND-ERASE                    VALUE '1'.
               88  SEND-DATAONLY                 VALUE '2'.
               88  SEND-DATAONLY-ALARM           VALUE '3'.
      *
       01  PROGRAM-TABLE.
      *
           05  PROGRAM-LIST.
               10  PROGRAM-1           PIC X(8)  VALUE 'CUSTINQ1'.
               10  PROGRAM-2           PIC X(8)  VALUE 'CUSTMNT1'.
               10  PROGRAM-3           PIC X(8)  VALUE 'ORDRENT1'.
           05  PROGRAM-NAME            REDEFINES PROGRAM-LIST
                                       OCCURS 3
                                       PIC X(8).
      *
       01  ACTION-ALPHA.
      *
           05  ACTION-NUM              PIC 9.
      *
       01  END-OF-SESSION-MESSAGE      PIC X(13) VALUE 'Session ended'.
      *
       01  RESPONSE-CODE               PIC S9(8) COMP.
      *
       01  COMMUNICATION-AREA          PIC X.
      *
       COPY MENSET1.
      *
       COPY DFHAID.
      *
       COPY ATTR.
      *
       LINKAGE SECTION.
      *
       01  DFHCOMMAREA                 PIC X.
      *
       PROCEDURE DIVISION.
      *
       0000-PROCESS-MASTER-MENU.
      *
           EVALUATE TRUE

               WHEN EIBCALEN = ZERO
                   MOVE LOW-VALUE TO MENMAP1O
                   MOVE -1 TO ACTIONL
                   SET SEND-ERASE TO TRUE
                   PERFORM 1400-SEND-MENU-MAP

               WHEN EIBAID = DFHCLEAR
                   MOVE LOW-VALUE TO MENMAP1O
                   MOVE -1 TO ACTIONL
                   SET SEND-ERASE TO TRUE
                   PERFORM 1400-SEND-MENU-MAP

               WHEN EIBAID = DFHPA1 OR DFHPA2 OR DFHPA3
                   CONTINUE

               WHEN EIBAID = DFHPF3 OR DFHPF12
                   PERFORM 2000-SEND-TERMINATION-MESSAGE
                   EXEC CICS
                       RETURN
                   END-EXEC

               WHEN EIBAID = DFHENTER
                   PERFORM 1000-PROCESS-MENU-MAP

               WHEN OTHER
                   MOVE 'Invalid key pressed.' TO MESSAGEO
                   MOVE -1 TO ACTIONL
                   SET SEND-DATAONLY-ALARM TO TRUE
                   PERFORM 1400-SEND-MENU-MAP

           END-EVALUATE.

           EXEC CICS
               RETURN TRANSID('MENU')
                      COMMAREA(COMMUNICATION-AREA)
                      LENGTH(1)
           END-EXEC.
      *
       1000-PROCESS-MENU-MAP.
      *
           PERFORM 1100-RECEIVE-MENU-MAP.
           PERFORM 1200-EDIT-MENU-DATA.
           IF VALID-DATA
               PERFORM 1300-BRANCH-TO-PROGRAM.
           SET SEND-DATAONLY-ALARM TO TRUE.
           PERFORM 1400-SEND-MENU-MAP.
      *
       1100-RECEIVE-MENU-MAP.
      *
           EXEC CICS
               RECEIVE MAP('MENMAP1')
                       MAPSET('MENSET1')
                       INTO(MENMAP1I)
           END-EXEC.
      *
       1200-EDIT-MENU-DATA.
      *
           IF ACTIONI NOT = '1' AND '2' AND '3'
               MOVE ATTR-REVERSE TO ACTIONH
               MOVE 'You must enter 1, 2, or 3.' TO MESSAGEO
               MOVE 'N' TO VALID-DATA-SW
           ELSE
               MOVE ACTIONI TO ACTION-ALPHA.
      *
       1300-BRANCH-TO-PROGRAM.
      *
               EXEC CICS
                   XCTL PROGRAM(PROGRAM-NAME(ACTION-NUM))
                        RESP(RESPONSE-CODE)
               END-EXEC
               MOVE 'That program is not available.' TO MESSAGEO.
      *
       1400-SEND-MENU-MAP.
      *
           IF SEND-ERASE
               EXEC CICS
                   SEND MAP('MENMAP1')
                        MAPSET('MENSET1')
                        FROM(MENMAP1O)
                        ERASE
                        CURSOR
               END-EXEC
           ELSE IF SEND-DATAONLY
               EXEC CICS
                   SEND MAP('MENMAP1')
                        MAPSET('MENSET1')
                        FROM(MENMAP1O)
                        DATAONLY
                        CURSOR
               END-EXEC
           ELSE IF SEND-DATAONLY-ALARM
               EXEC CICS
                   SEND MAP('MENMAP1')
                        MAPSET('MENSET1')
                        FROM(MENMAP1O)
                        DATAONLY
                        CURSOR
                        ALARM
               END-EXEC.
      *
       2000-SEND-TERMINATION-MESSAGE.
      *
           EXEC CICS
               SEND TEXT FROM(END-OF-SESSION-MESSAGE)
                         ERASE
                         FREEKB
           END-EXEC.
      *
